/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.NodeResultsUnavailableException;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.ResultValuesUnavailableException;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationMessage;
import oracle.cluster.verification.VerificationResult;
import oracle.cluster.verification.VerificationResultSet;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ResultSet
implements VerificationResultSet {
    public static final int SUCCESSFUL = 1;
    public static final int OPERATION_FAILED = 2;
    public static final int VERIFICATION_FAILED = 3;
    public static final int WARNING = 4;
    public static final int UNKNOWN = 5;
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private int m_status = 5;
    protected Hashtable m_resultTable = new Hashtable();
    private boolean m_hasNodeResults = true;
    private List<VerificationError> m_errorList = new ArrayList<VerificationError>();
    private int m_globalStatus = 5;
    private List<VerificationMessage> m_messageList = new ArrayList<VerificationMessage>();
    private List<CollectionElement> m_collectionList = new ArrayList<CollectionElement>();
    private String m_summary;

    public ResultSet() {
    }

    public ResultSet(int status) {
        this.m_status = status;
    }

    public int getStatus() {
        return this.m_status;
    }

    public void setStatus(int status) {
        this.m_globalStatus = status;
        this.setStatus();
    }

    public int getGlobalStatus() {
        return this.m_globalStatus;
    }

    public void setStatus() {
        boolean anySuccess = false;
        boolean anyVerificationFailure = false;
        boolean anyOperationFailure = false;
        boolean anyWarning = false;
        if (this.m_resultTable.size() == 0) {
            this.m_status = this.m_globalStatus;
            return;
        }
        Enumeration e = this.m_resultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            int status = ((Result)this.m_resultTable.get(node)).getStatus();
            if (status == 1) {
                anySuccess = true;
                continue;
            }
            if (status == 4) {
                anyWarning = true;
                continue;
            }
            if (status == 3) {
                anyVerificationFailure = true;
                continue;
            }
            if (status != 2) continue;
            anyOperationFailure = true;
        }
        if (this.m_globalStatus == 1) {
            anySuccess = true;
        } else if (this.m_globalStatus == 4) {
            anyWarning = true;
        } else if (this.m_globalStatus == 3) {
            anyVerificationFailure = true;
        } else if (this.m_globalStatus == 2) {
            anyOperationFailure = true;
        }
        this.m_status = anyOperationFailure ? 2 : (anyVerificationFailure ? 3 : (!anyWarning ? 1 : 4));
    }

    public void uploadResultSet(ResultSet sourceResultSet) {
        this.uploadResultSet(sourceResultSet, false);
    }

    public void uploadResultSet(ResultSet sourceResultSet, boolean isDestContainer) {
        this.traceResultSet("Target ResultSet BEFORE Upload===>");
        sourceResultSet.traceResultSet("Source ResultSet ===>");
        Hashtable t = sourceResultSet.getResultTable();
        if (t.size() == 0) {
            Trace.out((String)("NO element in the Source ResultSet. sourceResultSet global status " + sourceResultSet.getGlobalStatus()));
            if (this.m_globalStatus != 1) {
                this.setStatus(sourceResultSet.getGlobalStatus());
            }
        } else {
            Enumeration e = t.keys();
            while (e.hasMoreElements()) {
                Vector srcResultInfoSet;
                int size;
                String node = (String)e.nextElement();
                Result srcNodeRes = (Result)t.get(node);
                int status = srcNodeRes.getStatus();
                this.addResult(node, status);
                if (isDestContainer) continue;
                Result destNodeRes = (Result)this.m_resultTable.get(node);
                destNodeRes.addErrorDescription(srcNodeRes.getErrors());
                destNodeRes.addErrorInfo(srcNodeRes.getErrorInfoSet());
                destNodeRes.addVerificationMessages(srcNodeRes.getVerificationMessage());
                destNodeRes.setFixupAvailable(srcNodeRes.isFixupAvailable());
                if (srcNodeRes.hasResultValues()) {
                    destNodeRes.setHasResultValues(true);
                    try {
                        destNodeRes.setExpectedValue(srcNodeRes.getExpectedValue());
                        destNodeRes.setActualValue(srcNodeRes.getActualValue());
                    }
                    catch (ResultValuesUnavailableException rve) {
                        Trace.out((String)"ResultValuesUnavailableException thrown when hasResultValues() return true");
                    }
                }
                if ((size = (srcResultInfoSet = srcNodeRes.getResultInfoSet()).size()) > 0) {
                    for (int i = 0; i < size; ++i) {
                        destNodeRes.addResultInfo(srcResultInfoSet.elementAt(i));
                    }
                }
                destNodeRes.addCollectionElements(srcNodeRes.getCollectionElements());
            }
            this.setStatus();
        }
        this.m_errorList.addAll(sourceResultSet.getErrors());
        if (this.m_globalStatus != 1) {
            this.setStatus(sourceResultSet.getGlobalStatus());
        }
        this.m_messageList.addAll(sourceResultSet.getVerificationMessages());
        this.m_collectionList.addAll(sourceResultSet.getCollectionElements());
        this.traceResultSet("Target ResultSet AFTER Upload===>");
    }

    public void traceResultSet(String header) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("\n\n" + header + "\n\tOverall Status->" + ResultSet.resultsetStatusString(this.m_status) + "\n");
        Enumeration e = this.m_resultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)this.m_resultTable.get(node);
            int status = result.getStatus();
            if (Trace.isLevelEnabled((int)1)) {
                strBuf.append(result.traceResultInfo());
                continue;
            }
            strBuf.append("\n\t" + node + "-->" + Result.resultStatusString(status));
        }
        strBuf.append("\n\n");
        Trace.out((Object)strBuf);
    }

    public static String resultsetStatusString(int status) {
        if (status == 1) {
            return "SUCCESSFUL";
        }
        if (status == 2) {
            return "OPERATION_FAILED";
        }
        if (status == 3) {
            return "VERIFICATION_FAILED";
        }
        if (status == 4) {
            return "WARNING";
        }
        if (status == 5) {
            return "UNKNOWN";
        }
        return "--ERROR--";
    }

    public static String resultsetStatusString(OverallStatus status) {
        return status.name();
    }

    public boolean anyFailure() {
        Enumeration e = this.m_resultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            int status = ((Result)this.m_resultTable.get(node)).getStatus();
            if (status == 1 || status == 4 || status == 6) continue;
            return true;
        }
        return false;
    }

    public boolean allSuccess() {
        return this.m_status == 1 || this.m_status == 4;
    }

    public boolean anySuccess() {
        if (this.m_status == 1 || this.m_status == 4) {
            return true;
        }
        Enumeration e = this.m_resultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            int status = ((Result)this.m_resultTable.get(node)).getStatus();
            if (status != 1 && status != 4) continue;
            return true;
        }
        return false;
    }

    public boolean anyWarning() {
        Enumeration e = this.m_resultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            int status = ((Result)this.m_resultTable.get(node)).getStatus();
            if (status != 4) continue;
            return true;
        }
        return false;
    }

    public String[] getNodesWithStatus(int status) {
        Vector<String> nodeVect = new Vector<String>();
        Enumeration e = this.m_resultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            int nodeStatus = ((Result)this.m_resultTable.get(node)).getStatus();
            if (nodeStatus != status) continue;
            nodeVect.add(node);
        }
        return nodeVect.toArray(new String[nodeVect.size()]);
    }

    public String[] getFailureNodes() {
        Vector<String> nodeVect = new Vector<String>();
        Enumeration e = this.m_resultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            int nodeStatus = ((Result)this.m_resultTable.get(node)).getStatus();
            if (nodeStatus == 1 || nodeStatus == 4 || nodeStatus == 6) continue;
            nodeVect.add(node);
        }
        return nodeVect.toArray(new String[nodeVect.size()]);
    }

    public void getSuccNodes(Collection succNodes, Collection otherNodes) {
        ArrayList<String> succNodesLocal = new ArrayList<String>();
        Trace.out((String)"Checking for Success nodes from the total list of nodes in the resultset");
        succNodes.clear();
        otherNodes.clear();
        Enumeration e = this.m_resultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)this.m_resultTable.get(node);
            if (result.getStatus() == 1 || result.getStatus() == 4) {
                Trace.out((String)("Adding node " + node + " to list of Succ nodes"));
                succNodesLocal.add(node);
                continue;
            }
            otherNodes.add(node);
        }
        if (succNodesLocal.contains(VerificationUtil.getLocalHostName())) {
            succNodesLocal.remove(VerificationUtil.getLocalHostName());
            succNodesLocal.add(0, VerificationUtil.getLocalHostName());
        }
        succNodes.addAll(succNodesLocal);
    }

    public void getFailNodes(Collection failNodes, Collection otherNodes) {
        Trace.out((String)"Checking for Failed nodes from the total list of nodes in the resultset");
        failNodes.clear();
        otherNodes.clear();
        Enumeration e = this.m_resultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)this.m_resultTable.get(node);
            if (result.getStatus() == 3) {
                Trace.out((String)("Adding node " + node + " to list of Failed nodes"));
                failNodes.add(node);
                continue;
            }
            otherNodes.add(node);
        }
    }

    public void getUnknownNodes(Collection unknNodes, Collection otherNodes) {
        Trace.out((String)"Checking for nodes with operation failure or undefined status from the total list of nodes in the resultset");
        unknNodes.clear();
        otherNodes.clear();
        Enumeration e = this.m_resultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)this.m_resultTable.get(node);
            if (result.getStatus() != 1 && result.getStatus() != 3 && result.getStatus() != 4) {
                Trace.out((String)("Adding node " + node + " to list of undefined nodes"));
                unknNodes.add(node);
                continue;
            }
            otherNodes.add(node);
        }
    }

    public void filterResult(Collection succNodes, Collection failNodes, Collection unknNodes) {
        Trace.out((int)2, (String)"Entry");
        Vector otherNodes = new Vector();
        Trace.out((int)5, (String)"Getting succNodes list");
        this.getSuccNodes(succNodes, otherNodes);
        otherNodes.clear();
        Trace.out((int)5, (String)"Getting failNodes list");
        this.getFailNodes(failNodes, otherNodes);
        otherNodes.clear();
        Trace.out((int)5, (String)"Getting unknown Nodes list");
        this.getUnknownNodes(unknNodes, otherNodes);
    }

    public void addResult(String node, Result result) {
        this.m_resultTable.put(node, result);
        this.setStatus();
    }

    public void addResult(String node, int status) {
        this.addResult(new String[]{node}, status);
    }

    public void addResult(String node) {
        this.addResult(node, 5);
    }

    public void addResult(String[] nodeArr, int status) {
        this.addResult(Arrays.asList(nodeArr), status);
    }

    public void addResult(Collection nodes, int status) {
        for (Object node : nodes) {
            Result result = (Result)this.m_resultTable.get(node);
            if (result == null) {
                this.m_resultTable.put(node, new Result(node.toString(), status));
                continue;
            }
            result.setStatusConditionally(status);
        }
        this.setStatus();
    }

    public void addResult(String[] nodeArr) {
        this.addResult(nodeArr, 5);
    }

    public Result getResult(String node) {
        return (Result)this.m_resultTable.get(node);
    }

    public Hashtable getResultTable() {
        return this.m_resultTable;
    }

    public String[] getSuccNodes() {
        Vector succNodes = new Vector();
        Vector otherNodes = new Vector();
        this.getSuccNodes(succNodes, otherNodes);
        int arrSize = succNodes.size();
        return succNodes.toArray(new String[arrSize]);
    }

    @Override
    public List<String> getFailedNodes() {
        return Arrays.asList(this.getFailureNodes());
    }

    @Override
    public List<String> getSuccessfulNodes() {
        return Arrays.asList(this.getSuccNodes());
    }

    @Override
    public OverallStatus getOverallStatus() {
        if (this.m_status == 1) {
            return OverallStatus.SUCCESSFUL;
        }
        if (this.m_status == 2) {
            return OverallStatus.OPERATION_FAILED;
        }
        if (this.m_status == 3) {
            return OverallStatus.VERIFICATION_FAILED;
        }
        if (this.m_status == 4) {
            return OverallStatus.WARNING;
        }
        return OverallStatus.UNKNOWN;
    }

    @Override
    public boolean hasNodeResults() {
        if (this.m_status == 5) {
            return false;
        }
        return this.m_hasNodeResults;
    }

    @Override
    public List<VerificationResult> getNodeResults() throws NodeResultsUnavailableException {
        if (this.hasNodeResults()) {
            int tableSize = this.m_resultTable.size();
            if (tableSize == 0) {
                throw new NodeResultsUnavailableException(s_msgBundle.getMessage("7503", false));
            }
            return Arrays.asList(this.m_resultTable.values().toArray(new VerificationResult[tableSize]));
        }
        throw new NodeResultsUnavailableException(s_msgBundle.getMessage("7503", false));
    }

    @Override
    public VerificationResult getNodeResult(String node) throws NodeResultsUnavailableException {
        return this.getNodeResult(node, false);
    }

    public VerificationResult getNodeResult(String node, boolean addGlobalErrors) throws NodeResultsUnavailableException {
        if (this.hasNodeResults()) {
            Result nodeRes = (Result)this.m_resultTable.get(node);
            if (addGlobalErrors) {
                nodeRes.addErrorDescription(this.getErrors());
            }
            return nodeRes;
        }
        throw new NodeResultsUnavailableException(s_msgBundle.getMessage("7503", false));
    }

    @Override
    public List<VerificationError> getErrors() {
        return this.m_errorList;
    }

    public void addErrorDescription(ErrorDescription errorDesc) {
        this.m_errorList.add(errorDesc);
        VerificationLogData.logError(errorDesc.getErrorMessage());
    }

    public void addErrorDescription(String node, ErrorDescription errorDesc) {
        Result result = (Result)this.m_resultTable.get(node);
        if (result == null) {
            result = new Result(node);
        }
        this.m_resultTable.put(node, result);
        result.addErrorDescription(errorDesc);
    }

    public void addErrorDescription(String[] nodeList, ErrorDescription errorDesc) {
        for (String node : nodeList) {
            this.addErrorDescription(node, errorDesc);
        }
    }

    public void addErrorDescription(Collection nodeList, ErrorDescription errorDesc) {
        for (Object node : nodeList) {
            this.addErrorDescription(node.toString(), errorDesc);
        }
    }

    public void setHasNodeResults(boolean hasNodeResults) {
        this.m_hasNodeResults = hasNodeResults;
    }

    public void clear() {
        this.m_status = 5;
        this.m_resultTable.clear();
        this.m_hasNodeResults = true;
        this.m_errorList.clear();
        this.m_messageList.clear();
        this.m_collectionList.clear();
    }

    public String getResultSummary() {
        return this.m_summary;
    }

    public void setResultSummary(String summary) {
        this.m_summary = summary;
    }

    public void addVerificationMessage(VerificationMessage msg) {
        this.m_messageList.add(msg);
    }

    public List<VerificationMessage> getVerificationMessages() {
        return this.m_messageList;
    }

    public void addCollectionElement(CollectionElement element) {
        this.m_collectionList.add(element);
    }

    public void addCollectionElements(List<CollectionElement> elementList) {
        this.m_collectionList.addAll(elementList);
    }

    public void addCollectionElement(String node, CollectionElement element) {
        Result result = (Result)this.m_resultTable.get(node);
        if (result == null) {
            result = new Result(node);
        }
        this.m_resultTable.put(node, result);
        result.addCollectionElement(element);
    }

    public List<CollectionElement> getCollectionElements() {
        return this.m_collectionList;
    }

    public void turnAllErrorsToWarnings() {
        Trace.out((String)"Turning all result set errors into warnings...");
        this.m_status = 4;
        if (this.m_resultTable.size() == 0) {
            return;
        }
        Enumeration e = this.m_resultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result r = (Result)this.m_resultTable.get(node);
            int status = r.getStatus();
            if (status != 3 && status != 2) continue;
            r.setStatus(4);
        }
        this.setStatus();
        Trace.out((String)("Turned all result set errors into warnings. ResultSet status " + this.getStatus()));
    }
}

